/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogInitTable;
import com.ibm.hwmca.base.logd.EventLogSearchInfo;
import com.ibm.hwmca.base.logd.EventLogSummaryInfo;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletTerminatingException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TableSearchDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Map;

public class EventLogSummaryBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDBET";
    private static final String TRACE_MASKF = "XLOGDBEF";
    private static final String TRACE_MASKD = "XLOGDBED";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private EventLogSummaryInfo _eventLogSummaryInfo;
    private transient ItemDescriptor[] m_idEventLogSummaryTable;
    private transient ColumnDescriptor[] m_cdEventLogSummaryTableStructure;
    private transient int[] m_iEventLogSummaryTableSelection;
    private TableSearchDescriptor m_tsdEventLogSummaryTable;
    public static final String BUTTON_OK = "OkButton";
    public static final String BUTTON_REFRESH = "RefreshButton";
    public static final String BUTTON_CANCEL = "CancelButton";
    public static final String MENU_VIEW = "ViewMenu";
    public static final String MENU_PURGE = "PurgeMenu";
    public static final String MENU_FILE = "FileEventSumMenu";
    public static final String MENU_DISPLAY_REFCODE_DESCRIPTION = "DisplayRefcodeDescriptionMenu";
    public static final String ITEM_ALL_CLASSES = "ViewMenu.AllClassesItem";
    public static final String ITEM_SELECTED_CLASSES = "ViewMenu.SelectedClassItem";
    public static final String ITEM_PURGE_ALL_CLASSES = "PurgeMenu.PurgeAllClassesItem";
    public static final String ITEM_SAVE_LOG_LIST_TO_FILE = "FileEventSumMenu.SaveLogListFileItem";
    public static final String ITEM_SPECIFY_LOG_FILE_NAME = "FileEventSumMenu.SpecifyLogFileNameItem";
    public static final String ITEM_VIEW_FILE_LIST = "FileEventSumMenu.ViewDataFileListItem";
    public static final String ITEM_REFCODE_DESCRIPTION = "DisplayRefcodeDescriptionMenu.DisplayRefcodeDescriptionItem";
    public static final String DOUBLE_CLICK = "BlockIdItem";
    public static final String EVENT_TABLE_ITEM_SELECTED = "selected";
    private transient int _numRows;
    private transient int _startIndex;
    private transient int _endIndex;
    private transient int _rowStatus = 3;
    private transient int _searchIndex;
    private LocalizableText _lSearchTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.search.title");

    public void setEventLogSummaryInfo(EventLogSummaryInfo info) {
        this._eventLogSummaryInfo = info;
    }

    public ColumnDescriptor[] getEventLogSummaryTableRowStructure() {
        return this.m_cdEventLogSummaryTableStructure;
    }

    public int getEventLogSummaryTableRowStatus() {
        return 3;
    }

    public int getEventLogSummaryTableRowCount() {
        return this._numRows;
    }

    public ItemDescriptor[] getEventLogSummaryTableRowAt(int index) {
        if (this._startIndex > index || index > this._endIndex) {
            Trace.trace(TRACE_MASKF, "LogEventArray reqIndex = " + index);
            PanelTaskletRequest request = new PanelTaskletRequest();
            Integer requestedIndex = new Integer(index);
            request.setData("requestedIndex", requestedIndex);
            request.setData("action", "getData");
            try {
                Trace.trace(TRACE_MASKF, "Before request to retrieve logIndex=" + index);
                Map incrementalData = this.getIncrementalData(request);
                Trace.trace(TRACE_MASKF, "After request to retrieve logIndex=" + index);
                this._eventLogSummaryInfo = (EventLogSummaryInfo)incrementalData.get("eventLogSummary");
                this._startIndex = this._eventLogSummaryInfo.getStartIndex();
                this._endIndex = this._startIndex + this._eventLogSummaryInfo.getEventLogData().length - 1;
                Trace.trace(TRACE_MASKF, "LogEventArray startIndex=" + this._startIndex + " endIndex=" + this._endIndex);
            }
            catch (TaskletTerminatingException e) {
                Trace.trace(TRACE_MASKF, "Tasklet terminated while blocked while awaiting data");
                this._rowStatus = 1;
                new FrameworkLog(_logInfo, 1306, e).log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        if (this._rowStatus == 3) {
            int indexFormattedLog = index - this._startIndex;
            EventLogInitTable.setEventTableData(this._eventLogSummaryInfo.getEventLogData(indexFormattedLog), index, this.m_idEventLogSummaryTable);
            return this.m_idEventLogSummaryTable;
        }
        return null;
    }

    public void setEventLogSummaryTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getEventLogSummaryTableSelection() {
        return this.m_iEventLogSummaryTableSelection;
    }

    public void setEventLogSummaryTableSelection(int[] selected) throws IllegalUserDataException {
        int selLength = selected.length;
        this.m_iEventLogSummaryTableSelection = new int[selLength];
        for (int i = 0; i < selLength; ++i) {
            this.m_iEventLogSummaryTableSelection[i] = selected[i];
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void prepare() {
        Trace.trace(TRACE_MASKF, "DefLog=" + this._eventLogSummaryInfo.getDefaultLogFileDisplayed() + " refCode Exist=" + this._eventLogSummaryInfo.getRefcodeProgramExists());
        if (!this._eventLogSummaryInfo.getDefaultLogFileDisplayed()) {
            this.userTaskManager.removeGroup(MENU_PURGE);
            this.userTaskManager.setShown(BUTTON_REFRESH, false);
            Trace.trace(TRACE_MASKF, "Hide purge and refresh.  Not default log displayed");
        }
        if (!this._eventLogSummaryInfo.getDefaultLogFileDisplayed() || !this._eventLogSummaryInfo.getRefcodeProgramExists()) {
            this.userTaskManager.removeGroup(MENU_DISPLAY_REFCODE_DESCRIPTION);
            Trace.trace(TRACE_MASKF, "Hide refcodeDescrMenu item. Either refcode desc pgm doesn't exist or not def. log");
        }
        try {
            boolean isLocContext = ClientUserContext.staticIsLocalContext();
            Trace.trace(TRACE_MASKF, "isLocalContext=" + isLocContext);
            if (!isLocContext) {
                this.userTaskManager.removeGroup(MENU_FILE);
                Trace.trace(TRACE_MASKF, "Hide file menu. The  server are on different machines");
            }
        }
        catch (Exception uhe) {
            this.userTaskManager.removeGroup(MENU_FILE);
            Trace.trace(TRACE_MASKF, "Error querying to see if server are on same machine");
            Trace.trace(TRACE_MASKF, uhe);
        }
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> EventLogSummaryBean.load()");
        this._rowStatus = 3;
        this.m_iEventLogSummaryTableSelection = new int[0];
        this._numRows = this._eventLogSummaryInfo.getNumTotalEntries();
        this._startIndex = this._eventLogSummaryInfo.getStartIndex();
        this._endIndex = this._startIndex + this._eventLogSummaryInfo.getEventLogData().length - 1;
        this.m_idEventLogSummaryTable = new ItemDescriptor[6];
        for (int i = 0; i < 6; ++i) {
            this.m_idEventLogSummaryTable[i] = new ItemDescriptor();
        }
        Trace.trace(TRACE_MASKT, "<- EventLogSummaryBean.load()");
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> EventLogSummaryBean.panelAction()");
        PanelTaskletRequest request = null;
        try {
            request = new PanelTaskletRequest();
            request.setData("event", evt);
            request.setData("panelName", "eventSummary");
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKF, "event log's command = " + command);
            if (command.equals(BUTTON_OK) || command.endsWith(DOUBLE_CLICK) || command.equals(ITEM_REFCODE_DESCRIPTION) || command.equals(ITEM_VIEW_FILE_LIST)) {
                this.userTaskManager.storeElement("EventLogSummaryTable");
                if (this.getEventLogSummaryTableSelection() == null || this.getEventLogSummaryTableSelection().length == 0) {
                    Trace.trace(TRACE_MASKF, "No event logs were selected");
                    LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.eventsummary.title");
                    BaseMessageText myMess = new BaseMessageText("LOGSELEV");
                    LocalizableText ans = CommonMsgApp.showMessageBox(this.userTaskManager, lStrTitle, myMess, MsgType.INFORMATION_MESSAGE);
                } else {
                    Trace.trace(TRACE_MASKF, "Table item selected=" + this.getEventLogSummaryTableSelection()[0]);
                    request.setData(EVENT_TABLE_ITEM_SELECTED, new Integer(this.getEventLogSummaryTableSelection()[0]));
                    this.postTaskletRequest(request);
                }
            } else {
                this.postTaskletRequest(request);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in EventLogSummaryBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 1297, he).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- EventLogSummaryBean.panelAction()");
    }

    public void setEventLogSummaryTableRowsToBeRetrieved(int startIndex, int rowCount) {
        Trace.trace(TRACE_MASKT, "<-> setEventLogSummaryTableRowsToBeRetrieved()");
    }

    public int getEventLogSummaryTableNextSearchResult(int startIndex) {
        Trace.trace(TRACE_MASKT, "<-> getEventLogSummaryTableNextSearchResult()");
        return -1;
    }

    public int getEventLogSummaryTableNextSearchResult(int startIndex, boolean searchForward) {
        Trace.trace(TRACE_MASKT, "<-> getEventLogSummaryTableNextSearchResult(startSearchIndex,searchForward)");
        String searchText = this.m_tsdEventLogSummaryTable.getText();
        String[] wData = this.m_tsdEventLogSummaryTable.getColumnNames();
        PanelTaskletRequest request = null;
        request = new PanelTaskletRequest();
        Trace.trace(TRACE_MASKF, "startSearchIndex=" + startIndex + " numRows=" + this._numRows + " searchForward=" + searchForward);
        try {
            String whatData = null;
            whatData = wData != null ? wData[0] : null;
            int matchLocation = this.m_tsdEventLogSummaryTable.getMatchLocation();
            boolean matchCase = this.m_tsdEventLogSummaryTable.isMatchCase();
            this._searchIndex = -1;
            Trace.trace(TRACE_MASKF, "searchLogInfo: searchText=" + searchText + " startSearchIndex=" + startIndex, " matchLoc=" + matchLocation + " matchCase=" + matchCase + " searchForward=" + searchForward);
            if (whatData == null) {
                Trace.trace(TRACE_MASKF, "whatData(column search) is null");
            } else {
                Trace.trace(TRACE_MASKF, "whatData= " + whatData);
            }
            EventLogSearchInfo eventLogSearchInfo = new EventLogSearchInfo(searchText, whatData, matchLocation, matchCase, searchForward, startIndex);
            request.setData("searchData", eventLogSearchInfo);
            request.setData("action", "search");
            try {
                Trace.trace(TRACE_MASKF, "Before request to do search in log data");
                Map incrementalData = this.getIncrementalData(request);
                Trace.trace(TRACE_MASKF, "After request to do search in log data");
                Integer sIndex = (Integer)incrementalData.get("searchIndex");
                this._searchIndex = sIndex;
                Trace.trace(TRACE_MASKF, "index returned from search=" + this._searchIndex);
            }
            catch (TaskletTerminatingException e) {
                Trace.trace(TRACE_MASKF, "Tasklet terminated while searching");
                new FrameworkLog(_logInfo, 1308, e).log(FrameworkLogAttributes.INFO_LOG);
                this.displayMsg("LOGDUSEA", this._lSearchTitle, MsgType.INFORMATION_MESSAGE);
                this._searchIndex = -2;
            }
        }
        catch (HException hexc) {
            Trace.trace(TRACE_MASKF, "Error caught in EventLogSummaryBean.getEventLogSummaryTableNextSearchResult()");
            Trace.trace(TRACE_MASKF, hexc);
            new FrameworkLog(_logInfo, 1309, hexc).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
            this._searchIndex = -2;
        }
        return this._searchIndex;
    }

    public void setEventLogSummaryTableSearchCriteria(TableSearchDescriptor criteria) {
        Trace.trace(TRACE_MASKT, "getEventLogSummaryTableSearchCriteria()");
        this.m_tsdEventLogSummaryTable = criteria;
    }

    private void displayMsg(String msg, LocalizableText title, MsgType msgType) throws HException {
        LocalizableText _lSearchTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.search.title");
        BaseMessageText myMess = new BaseMessageText(msg);
        CommonMsgApp.showMessageBox(this.userTaskManager, title, myMess, msgType);
    }
}

